/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWHasParameterDefs;
import filenet.vw.api.VWActionType;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAssociationTargetType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWJoinType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWRollbackInstruction;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWRuleSetDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSimpleInstruction;
import filenet.vw.api.VWSplitType;
import filenet.vw.api.VWStepPaletteDefinition;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWFEInstruction;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXPDL_20_parser;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.Vector;

public final class VWCompoundStepDefinition
extends VWMapNode
implements Serializable,
IVWHasParameterDefs {
    private static final long serialVersionUID = 7510L;
    private VWInstructionDefinition[] instructions;
    private VWArrayHandler instructionsHandler = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:19:40 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/7 $";
    }

    public VWParameterDefinition getParameterDefinition(String theName) throws VWException {
        return null;
    }

    protected VWCompoundStepDefinition(VWMapDefinition theMap, String theName, int theStepId) throws VWException {
        super(theMap, theName, theStepId);
        try {
            Class<?> instructionClass = Class.forName("filenet.vw.api.VWInstructionDefinition");
            this.instructionsHandler = new VWArrayHandler(instructionClass);
        }
        catch (Exception e) {
            throw new VWException("vw.api.VWCompoundStepDefinitionErrorInArrayHandler", "exception initializing the array handler, {0}", e.toString());
        }
    }

    protected VWCompoundStepDefinition(VWMapDefinition theMap) throws VWException {
        super(theMap);
        try {
            Class<?> instructionClass = Class.forName("filenet.vw.api.VWInstructionDefinition");
            this.instructionsHandler = new VWArrayHandler(instructionClass);
        }
        catch (Exception e) {
            throw new VWException("vw.api.VWCompoundStepDefinitionErrorInArrayHandler", "exception initializing the array handler, {0}", e.toString());
        }
    }

    protected VWCompoundStepDefinition(VWStepPaletteDefinition theStepPalette) throws VWException {
        super(theStepPalette);
        try {
            Class<?> instructionClass = Class.forName("filenet.vw.api.VWInstructionDefinition");
            this.instructionsHandler = new VWArrayHandler(instructionClass);
        }
        catch (Exception e) {
            throw new VWException("vw.api.VWCompoundStepDefinitionErrorInArrayHandler", "exception initializing the array handler, {0}", e.toString());
        }
    }

    protected VWCompoundStepDefinition(int theStepId) throws VWException {
        super(theStepId);
        try {
            Class<?> instructionClass = Class.forName("filenet.vw.api.VWInstructionDefinition");
            this.instructionsHandler = new VWArrayHandler(instructionClass);
        }
        catch (Exception e) {
            throw new VWException("vw.api.VWCompoundStepDefinitionErrorInArrayHandler", "exception initializing the array handler, {0}", e.toString());
        }
    }

    public VWInstructionDefinition[] getInstructions() throws VWException {
        return (VWInstructionDefinition[])this.instructionsHandler.getElements(this.instructions);
    }

    public void setInstructions(VWInstructionDefinition[] theInstructions) throws VWException {
        if (theInstructions.length != this.instructionsHandler.getElementCount()) {
            throw new VWException("vw.api.VWCompoundStepDefinitionSetInstructionsBadLength", "Parameter theInstructions actual length is {0}, expected length should be {1}.", String.valueOf(theInstructions.length), String.valueOf(this.instructionsHandler.getElementCount()));
        }
        for (int i = 0; i < theInstructions.length; ++i) {
            this.instructions[i] = theInstructions[i];
        }
    }

    public void deleteInstruction(int theInstructionId) throws VWException {
        int index = this.instructionsHandler.getIndexFromIntFieldValue(this.instructions, "instructionId", theInstructionId);
        if (index == -1) {
            throw new VWException("vw.api.VWVWCompoundStepDefinitionInstructionNotFound", "No instruction found with ID equal to {0} in this compound step definition.", String.valueOf(theInstructionId));
        }
        if (this.instructions[index].getAction() == 40 && ((VWReceiveInstruction)this.instructions[index]).getPartnerLinkName() != null && ((VWReceiveInstruction)this.instructions[index]).getPartnerLinkName().length() > 0 && this.getMap() != null) {
            this.getMap().getWorkflow().getPartnerLink(((VWReceiveInstruction)this.instructions[index]).getPartnerLinkName()).removeReceiveStepRef((VWReceiveInstruction)this.instructions[index]);
        }
        if (this.instructions[index].getAction() == 41 && ((VWReplyInstruction)this.instructions[index]).getPartnerLinkName() != null && ((VWReplyInstruction)this.instructions[index]).getPartnerLinkName().length() > 0 && this.getMap() != null) {
            this.getMap().getWorkflow().getPartnerLink(((VWReplyInstruction)this.instructions[index]).getPartnerLinkName()).removeReplyStepRef((VWReplyInstruction)this.instructions[index]);
        }
        this.instructionsHandler.deleteElementFromArray(this.instructions, index);
    }

    protected VWInstructionDefinition createEmptyInstruction() throws VWException {
        VWSimpleInstruction newInstruction = new VWSimpleInstruction();
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createCallInstruction(String theMapName) throws VWException {
        String[] p = new String[]{theMapName};
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 5, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createDelayInstruction(String delay) throws VWException {
        String[] p = new String[]{delay};
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 7, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createWFEInstruction(String theTimeOut, String theEventNumLocation) throws VWException {
        VWWFEInstruction newInstruction = new VWWFEInstruction(this, this.getNextAvailableId(), theTimeOut, theEventNumLocation);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createInvokeInstruction(String thePartnerLinkName, String theOperationName) throws VWException {
        VWInvokeInstruction newInstruction = new VWInvokeInstruction(this, this.getNextAvailableId(), thePartnerLinkName, theOperationName);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createReplyInstruction(String thePartnerLinkName, String theOperationName) throws VWException {
        VWReplyInstruction newInstruction = new VWReplyInstruction(this, this.getNextAvailableId(), thePartnerLinkName, theOperationName);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createReceiveInstruction(String thePartnerLinkName, String theOperationName) throws VWException {
        VWReceiveInstruction newInstruction = new VWReceiveInstruction(this, this.getNextAvailableId(), thePartnerLinkName, theOperationName);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createEndTimerInstruction(String theTimer) throws VWException {
        String[] p = new String[]{theTimer};
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 9, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createResumeTimerInstruction(String theTimer) throws VWException {
        String[] p = new String[]{theTimer};
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 13, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createSuspendTimerInstruction(String timer) throws VWException {
        String[] p = new String[]{timer};
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 16, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createReturnInstruction(String retryOption) throws VWException {
        String[] p = new String[]{retryOption};
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 14, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createExecuteInstruction(String theQueueName, String theOperationName, String[] theParamList) throws VWException {
        String[] p = new String[2 + theParamList.length];
        p[0] = theQueueName;
        p[1] = theOperationName;
        for (int i = 2; i < p.length; ++i) {
            p[i] = theParamList[i - 2];
        }
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 23, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createDatabaseExecuteInstruction(String theDatabaseName, String theProcedureName, String[] theParamList) throws VWException {
        String[] p = new String[2 + theParamList.length];
        p[0] = theDatabaseName;
        p[1] = theProcedureName;
        for (int i = 2; i < p.length; ++i) {
            p[i] = theParamList[i - 2];
        }
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 37, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createCreateInstruction(String theWorkClassName, String[][] theFieldAssignList) throws VWException {
        int noOfAssignments = theFieldAssignList == null ? 0 : theFieldAssignList.length;
        String[] p = new String[1 + 2 * noOfAssignments];
        p[0] = theWorkClassName;
        for (int i = 0; i < noOfAssignments; ++i) {
            if (theFieldAssignList[i] == null) {
                throw new VWException("vw.api.VWCompoundStepDefinitionAssignmentArrayNullRow", "Assignment array has a null row, index {0}.", String.valueOf(i));
            }
            if (theFieldAssignList[i].length != 2) {
                throw new VWException("vw.api.VWCompoundStepDefinitionAssignmentArrayWrongDimension", "Assignment array wrong dimension, row {0} has {1} elements, should have 2 (representing the left and right values of the assignment)", String.valueOf(i), String.valueOf(theFieldAssignList[i].length));
            }
            if (theFieldAssignList[i][0] == null || theFieldAssignList[i][1] == null) {
                throw new VWException("vw.api.VWCompoundStepDefinitionAssignmentArrayNullElement", "Assignment array contains a null entry in row {0}", String.valueOf(i));
            }
            p[1 + i * 2] = theFieldAssignList[i][0];
            p[2 + i * 2] = theFieldAssignList[i][1];
        }
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 6, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createRollbackCheckpointInstruction(String theReDoFlag, String theCompCallIS, String[] theNonRollbackFieldList) throws VWException {
        int fieldListLen = theNonRollbackFieldList != null ? theNonRollbackFieldList.length : 0;
        String[] p = new String[fieldListLen];
        for (int i = 0; i < fieldListLen; ++i) {
            p[i] = theNonRollbackFieldList[i];
        }
        VWRollbackInstruction newInstruction = new VWRollbackInstruction(this, this.getNextAvailableId(), p, theCompCallIS, theReDoFlag);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createAssignInstruction(String[][] assignPairs) throws VWException {
        int arrayLen = assignPairs == null ? 0 : assignPairs.length;
        String[] p = new String[2 * arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            if (assignPairs[i] == null) {
                throw new VWException("vw.api.VWCompoundStepDefinitionAssignmentArrayNullRow", "Assignment array has a null row, index {0}.", String.valueOf(i));
            }
            if (assignPairs[i].length != 2) {
                throw new VWException("vw.api.VWCompoundStepDefinitionAssignmentArrayWrongDimension", "Assignment array wrong dimension, row {0} has {1} elements, should have 2 (representing the left and right values of the assignment)", String.valueOf(i), String.valueOf(assignPairs[i].length));
            }
            if (assignPairs[i][0] == null || assignPairs[i][1] == null) {
                throw new VWException("vw.api.VWCompoundStepDefinitionAssignmentArrayNullElement", "Assignment array contains a null entry in row {0}", String.valueOf(i));
            }
            p[i * 2] = assignPairs[i][0];
            p[i * 2 + 1] = assignPairs[i][1];
        }
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 0, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createTerminateInstruction() throws VWException {
        return this.createZeroParamInstruction(17);
    }

    public VWInstructionDefinition createTerminateBranchInstruction() throws VWException {
        return this.createZeroParamInstruction(17);
    }

    public VWInstructionDefinition createTerminateProcessInstruction() throws VWException {
        return this.createZeroParamInstruction(42);
    }

    public VWInstructionDefinition createNoOpInstruction() throws VWException {
        return this.createZeroParamInstruction(24);
    }

    public VWInstructionDefinition createBeginCheckPointInstruction() throws VWException {
        return this.createZeroParamInstruction(27);
    }

    public VWInstructionDefinition createEndCheckPointInstruction() throws VWException {
        return this.createZeroParamInstruction(28);
    }

    public VWInstructionDefinition createEndAllTimersInstruction() throws VWException {
        return this.createZeroParamInstruction(8);
    }

    public VWInstructionDefinition createBeginTimerInstruction(String theTimerName, String theExpirationTime, String theISName, String thePreemptiveExpirationExpr) throws VWException {
        String[] p = null;
        if (thePreemptiveExpirationExpr == null) {
            p = new String[3];
        } else {
            p = new String[4];
            p[3] = thePreemptiveExpirationExpr;
        }
        p[0] = theTimerName;
        p[1] = theExpirationTime;
        p[2] = theISName;
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 1, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public VWInstructionDefinition createLogInstruction(String theEventType, String theEventText) throws VWException {
        String[] p = new String[]{theEventType, theEventText};
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), 38, p);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    protected VWInstructionDefinition createZeroParamInstruction(int theAction) throws VWException {
        if (VWActionType.numberOfParameters(theAction) != 0) {
            throw new VWException("vw.api.VWCompoundStepDefinitionActionNeedsMoreThanZeroParams", "The action {0} needs more than 0 parameters.", VWActionType.typeToString(theAction));
        }
        VWSimpleInstruction newInstruction = new VWSimpleInstruction(this, this.getNextAvailableId(), theAction, null);
        this.instructions = (VWInstructionDefinition[])this.instructionsHandler.addElementToArray(this.instructions, newInstruction);
        return newInstruction;
    }

    public void validate(VWSession theSession, Vector EDefVector) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext);
    }

    protected void validate(VWValidationContext validationContext) throws VWException {
        int i;
        int actualInstructionCount = this.instructionsHandler.getElementCount();
        for (i = 0; i < actualInstructionCount; ++i) {
            this.instructions[i].validate(validationContext, this);
        }
        for (i = 0; i < 3; ++i) {
            if (this.ruleSets[i] == null || this.ruleSets[i].length <= 0) continue;
            for (int j = 0; j < this.ruleSets[i].length; ++j) {
                VWWorkflowDefinition wflDef = null;
                VWWorkflowSignature wflSignature = null;
                if (this.getMap() != null && this.getMap().getWorkflow() != null) {
                    wflDef = this.getMap().getWorkflow();
                }
                if (wflDef != null) {
                    wflSignature = wflDef.getBaseWorkflowSignature(validationContext);
                }
                if (wflDef != null && (wflDef.isExistingRuleSet(this.ruleSets[i][j]) || wflSignature != null && wflSignature.isRulesetName(this.ruleSets[i][j]))) continue;
                VWString theMessage = new VWString("vw.api.VWCompoundStepDefinitionRuleSetNotExist", "The step rule refers to a non-existent ruleset (\"{0}\").", this.ruleSets[i][j]);
                VWValidationError theError = new VWValidationError(1, 1, this.getName(), this.ruleSets[i][j], theMessage.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError);
            }
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        int i;
        VWRouteDefinition[] r;
        String ATTRIB_INDENT = "\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWCompoundStepDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t<CompoundStep\n");
        theBuffer.append(ATTRIB_INDENT + "StepId=\"" + Integer.toString(this.getStepId()) + "\"");
        if (this.getName() != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"");
        }
        if (this.getDescription() != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Description=\"" + VWXMLHandler.toXMLString(this.getDescription()) + "\"");
        }
        if (this.getDocumentation() != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Documentation=\"" + VWXMLHandler.toXMLString(this.getDocumentation()) + "\"");
        }
        if (this.getAuthorTool() != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "AuthorTool=\"" + VWXMLHandler.toXMLString(this.getAuthorTool()) + "\"");
        }
        if (this.getLocation() != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "XCoordinate=\"" + Integer.toString(this.getLocation().x) + "\"");
            theBuffer.append("\n" + ATTRIB_INDENT + "YCoordinate=\"" + Integer.toString(this.getLocation().y) + "\"");
        }
        if (this.getJoinStepId() != -1) {
            theBuffer.append("\n" + ATTRIB_INDENT + "JoinStepId=\"" + Integer.toString(this.getJoinStepId()) + "\"");
        }
        theBuffer.append("\n" + ATTRIB_INDENT + "JoinType=\"" + VWJoinType.typeToString(this.getJoinType()) + "\"");
        theBuffer.append("\n" + ATTRIB_INDENT + "SplitType=\"" + VWSplitType.typeToString(this.getSplitType()) + "\"");
        theBuffer.append(">\n");
        VWInstructionDefinition[] InstArray = this.getInstructions();
        if (InstArray != null) {
            for (int i2 = 0; i2 < InstArray.length; ++i2) {
                InstArray[i2].toXML(theBuffer);
            }
        }
        if ((r = this.getNextRoutes()) != null) {
            for (i = 0; i < r.length; ++i) {
                r[i].toXML(theBuffer);
            }
        }
        block10: for (i = 0; i < 3; i += 2) {
            if (this.ruleSets[i] == null || this.ruleSets[i].length <= 0) continue;
            switch (i) {
                case 0: {
                    theBuffer.append(ATTRIB_INDENT + "<PreRule>\n");
                    break;
                }
                case 2: {
                    theBuffer.append(ATTRIB_INDENT + "<PostRule>\n");
                }
            }
            for (int j = 0; j < this.ruleSets[i].length; ++j) {
                theBuffer.append(ATTRIB_INDENT + "\t" + "<Expression Val=\"" + VWXMLHandler.toXMLString(this.ruleSets[i][j]) + "\" />\n");
            }
            switch (i) {
                case 0: {
                    theBuffer.append(ATTRIB_INDENT + "</PreRule>\n");
                    continue block10;
                }
                case 2: {
                    theBuffer.append(ATTRIB_INDENT + "</PostRule>\n");
                }
            }
        }
        if (this.attributes != null) {
            this.attributes.toXML(theBuffer, ATTRIB_INDENT);
        }
        theBuffer.append("\t\t</CompoundStep>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        VWSimpleInstruction inst;
        String[] params;
        int actionType;
        int i;
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        String indentD = VWXMLHandler.incXMLIndent(indentC);
        String indentE = VWXMLHandler.incXMLIndent(indentD);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWCompoundStepDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        VWWorkflowDefinition wfdef = this.getMap().getWorkflow();
        if (wfdef.getWorkflowCollection() == null) {
            throw new VWException("vw.api.VWCompoundStepDefinitionNullWorkflowCollection", "The XPDL string cannot be created for this step definition. The necessary reference to a containing workflow collection definition is null. \nEnsure that the workflow collection definition containing this step definition is specified.");
        }
        theBuffer.append(indentA + "<Activity Id=\"Workflow" + wfdef.getWorkflowCollection().getWorkflowIndex(wfdef.getName()) + ".Map" + wfdef.getMapIndex(this.getMap().getName()) + "." + VWAssociationTargetType.typeToString(1) + Integer.toString(this.getStepId()) + "\"");
        if (this.getName() != null) {
            theBuffer.append(" Name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"");
        }
        if (this.stepId == 0) {
            theBuffer.append(" StartActivity=\"true\"");
        }
        theBuffer.append(" fn:CompoundStep=\"true\"");
        if (this.getAuthorTool() != null) {
            theBuffer.append(" fn:AuthorTool=\"").append(this.getAuthorTool()).append("\"");
        }
        theBuffer.append(">\n");
        if (this.getDescription() != null) {
            theBuffer.append(indentB + "<Description>" + VWXMLHandler.toXMLString(this.getDescription()) + "</Description>\n");
        }
        VWInstructionDefinition[] InstructionArray = this.getInstructions();
        boolean canHandleInstructionsWithXPDL = true;
        boolean foundSpecialActivity = false;
        boolean foundAssignments = false;
        if (InstructionArray != null) {
            for (i = 0; i < InstructionArray.length; ++i) {
                actionType = InstructionArray[i].getAction();
                if (actionType == 5 || actionType == 6 || actionType == 39 || actionType == 40 || actionType == 41 || actionType == 17) {
                    if (foundSpecialActivity) {
                        canHandleInstructionsWithXPDL = false;
                    } else if ((actionType == 6 || actionType == 5) && (params = (inst = (VWSimpleInstruction)InstructionArray[i]).getParams()) != null && params.length > 0) {
                        int index = -1;
                        try {
                            index = actionType == 6 ? this.getMap().getWorkflow().getWorkflowCollection().getWorkflowIndex(params[0]) : wfdef.getMapIndex(params[0]);
                        }
                        catch (VWException ex) {
                            // empty catch block
                        }
                        if (index == -1 || actionType == 6 && params.length > 1) {
                            canHandleInstructionsWithXPDL = false;
                        }
                    }
                    foundSpecialActivity = true;
                    continue;
                }
                if (actionType == 0) {
                    foundAssignments = true;
                    continue;
                }
                canHandleInstructionsWithXPDL = false;
            }
        }
        if (canHandleInstructionsWithXPDL && foundSpecialActivity) {
            for (i = 0; i < InstructionArray.length; ++i) {
                actionType = InstructionArray[i].getAction();
                if (actionType == 5) {
                    inst = (VWSimpleInstruction)InstructionArray[i];
                    params = inst.getParams();
                    theBuffer.append(indentB + "<BlockActivity ActivitySetId=\"Process" + wfdef.getWorkflowCollection().getWorkflowIndex(wfdef.getName()) + ".Map" + wfdef.getMapIndex(params[0]) + "\"/>\n");
                    continue;
                }
                if (actionType == 17) {
                    theBuffer.append(indentB + "<Event>\n");
                    theBuffer.append(indentC + "<EndEvent/>\n");
                    theBuffer.append(indentB + "</Event>\n");
                    continue;
                }
                if (actionType != 6 && actionType != 39 && actionType != 40 && actionType != 41) continue;
                theBuffer.append(indentB + "<Implementation>\n");
                if (actionType == 6) {
                    inst = (VWSimpleInstruction)InstructionArray[i];
                    params = inst.getParams();
                    if (params != null && params.length > 0) {
                        theBuffer.append(indentC + "<SubFlow Id=\"" + this.getMap().getWorkflow().getWorkflowCollection().getWorkflowIndex(params[0]) + "\">\n");
                        if (params.length > 1) {
                            theBuffer.append(indentD + "<ActualParameters>\n");
                            for (int p = 2; p < params.length; p += 2) {
                                if (params[p] == null) continue;
                                theBuffer.append(indentE + "<ActualParameter>" + VWXMLHandler.toXMLString(params[p]) + "</ActualParameter>\n");
                            }
                            theBuffer.append(indentD + "</ActualParameters>\n");
                        }
                        theBuffer.append(indentC + "</SubFlow>\n");
                    }
                } else {
                    theBuffer.append(indentC + "<Task>\n");
                    if (actionType == 39) {
                        ((VWInvokeInstruction)InstructionArray[i]).toXPDL(indentD, theBuffer);
                    } else if (actionType == 40) {
                        ((VWReceiveInstruction)InstructionArray[i]).toXPDL(indentD, theBuffer);
                    } else if (actionType == 41) {
                        ((VWReplyInstruction)InstructionArray[i]).toXPDL(indentD, theBuffer);
                    }
                    theBuffer.append(indentC + "</Task>\n");
                }
                theBuffer.append(indentB + "</Implementation>\n");
            }
        }
        if (this.getJoinType() != 3 || this.getSplitType() != 3) {
            theBuffer.append(indentB + "<TransitionRestrictions>\n");
            theBuffer.append(indentC + "<TransitionRestriction>\n");
            if (this.getJoinType() == 1) {
                theBuffer.append(indentD + "<Join Type=\"AND\"/>\n");
            } else if (this.getJoinType() == 2) {
                theBuffer.append(indentD + "<Join Type=\"XOR\"/>\n");
            }
            if (this.getSplitType() == 1) {
                theBuffer.append(indentD + "<Split Type=\"AND\"/>\n");
            } else if (this.getSplitType() == 2) {
                theBuffer.append(indentD + "<Split Type=\"XOR\"/>\n");
            }
            theBuffer.append(indentC + "</TransitionRestriction>\n");
            theBuffer.append(indentB + "</TransitionRestrictions>\n");
        }
        if (canHandleInstructionsWithXPDL && foundAssignments) {
            boolean foundOne = false;
            String assignTime = "Start";
            for (int i2 = 0; i2 < InstructionArray.length; ++i2) {
                if (InstructionArray[i2].getAction() != 0) {
                    assignTime = "End";
                    continue;
                }
                VWSimpleInstruction inst2 = (VWSimpleInstruction)InstructionArray[i2];
                String[] params2 = inst2.getParams();
                if (params2 == null) continue;
                for (int p = 0; p < params2.length; ++p) {
                    if (params2[p] == null) continue;
                    if (!foundOne) {
                        theBuffer.append(indentB + "<Assignments>\n");
                        foundOne = true;
                    }
                    theBuffer.append(indentC + "<Assignment AssignTime=\"" + assignTime + "\">\n");
                    theBuffer.append(indentD + "<Target>" + VWXMLHandler.toXMLString(params2[p]) + "</Target>\n");
                    theBuffer.append(indentD + "<Expression>" + VWXMLHandler.toXMLString(params2[++p]) + "</Expression>\n");
                    theBuffer.append(indentC + "</Assignment>\n");
                }
            }
            if (foundOne) {
                theBuffer.append(indentB + "</Assignments>\n");
            }
        }
        VWXPDL_20_parser.writeXPDLNodeGraphicsInfos(this.getLocation(), null, null, false, this.getOriginalNodeGraphicsInfosNode(), indentB, theBuffer);
        theBuffer.append(indentB + "<Extensions/>\n");
        theBuffer.append(indentB + "<fn:CompoundStep");
        if (this.getDocumentation() != null) {
            theBuffer.append(" Documentation=\"" + VWXMLHandler.toXMLString(this.getDocumentation()) + "\"");
        }
        theBuffer.append(">\n");
        if (!canHandleInstructionsWithXPDL && InstructionArray != null) {
            for (i = 0; i < InstructionArray.length; ++i) {
                if (InstructionArray[i].action == 19) {
                    ((VWWFEInstruction)InstructionArray[i]).toXPDL(indentC, theBuffer);
                    continue;
                }
                InstructionArray[i].toXML(theBuffer);
            }
        }
        block16: for (i = 0; i < 3; i += 2) {
            if (this.ruleSets[i] == null || this.ruleSets[i].length <= 0) continue;
            switch (i) {
                case 0: {
                    theBuffer.append(indentC + "<PreRule>\n");
                    break;
                }
                case 2: {
                    theBuffer.append(indentC + "<PostRule>\n");
                }
            }
            for (int j = 0; j < this.ruleSets[i].length; ++j) {
                theBuffer.append(indentD + "<Expression Val=\"" + VWXMLHandler.toXMLString(this.ruleSets[i][j]) + "\" />\n");
            }
            switch (i) {
                case 0: {
                    theBuffer.append(indentC + "</PreRule>\n");
                    continue block16;
                }
                case 2: {
                    theBuffer.append(indentC + "</PostRule>\n");
                }
            }
        }
        if (this.attributes != null) {
            this.attributes.toXML(theBuffer, indentC);
        }
        theBuffer.append(indentB + "</fn:CompoundStep>\n");
        theBuffer.append(indentA + "</Activity>\n");
    }

    public void setRuleSets(int ruleSetSelector, VWRuleSetDefinition[] theRules) throws VWException {
        if (ruleSetSelector == 1) {
            throw new VWException("vw.api.VWCompoundStepDefinitionInvalidRuleSetSelector", "The parameter ruleSetSelector {0} is invalid, UPDATE_RULESETS cannot be specified for a VWCompoundStepDefinition.", String.valueOf(ruleSetSelector));
        }
        super.setRuleSets(ruleSetSelector, theRules);
    }

    public String toString() {
        return this.getName();
    }

    protected Object clone() {
        try {
            VWCompoundStepDefinition compStepDef = (VWCompoundStepDefinition)super.clone();
            if (this.instructions != null) {
                compStepDef.instructions = (VWInstructionDefinition[])this.instructions.clone();
                for (int i = 0; i < this.instructions.length; ++i) {
                    if (this.instructions[i] == null) continue;
                    compStepDef.instructions[i] = (VWInstructionDefinition)this.instructions[i].clone();
                    if (compStepDef.instructions[i].getAction() == 39) {
                        ((VWInvokeInstruction)compStepDef.instructions[i]).setMyStepReference(compStepDef);
                    }
                    if (compStepDef.instructions[i].getAction() == 40) {
                        ((VWReceiveInstruction)compStepDef.instructions[i]).setMyStepReference(compStepDef);
                    }
                    if (compStepDef.instructions[i].getAction() != 41) continue;
                    ((VWReplyInstruction)compStepDef.instructions[i]).setMyStepReference(compStepDef);
                }
                compStepDef.instructionsHandler = (VWArrayHandler)this.instructionsHandler.clone();
            }
            return compStepDef;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

